/*
 * g722_1 - a library for the G.722.1 and Annex C codecs
 *
 * huff_tab.c
 *
 * Adapted by Steve Underwood <steveu@coppice.org> from the reference
 * code supplied with ITU G.722.1, which is:
 *
 *    2004 Polycom, Inc.
 *   All rights reserved.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $Id: huff_tab.c,v 1.7 2008/09/30 14:06:40 steveu Exp $
 */

/*! \file */

#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <inttypes.h>
#include <stdlib.h>

#include "g722_1/g722_1.h"
#include "defs.h"
#include "huff_tab.h"

const int16_t differential_region_power_bits[MAX_NUMBER_OF_REGIONS][DIFF_REGION_POWER_LEVELS] =
{
    {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99}, 
    { 4,  6,  5,  5,  4,  4,  4,  4,  4,  4,  3,  3,  3,  4,  5,  7,  8,  9, 11, 11, 12, 12, 12, 12}, 
    {10,  8,  6,  5,  5,  4,  3,  3,  3,  3,  3,  3,  4,  5,  7,  9, 11, 12, 13, 15, 15, 15, 16, 16}, 
    {12, 10,  8,  6,  5,  4,  4,  4,  4,  4,  4,  3,  3,  3,  4,  4,  5,  5,  7,  9, 11, 13, 14, 14}, 
    {13, 10,  9,  9,  7,  7,  5,  5,  4,  3,  3,  3,  3,  3,  4,  4,  4,  5,  7,  9, 11, 13, 13, 13}, 
    {12, 13, 10,  8,  6,  6,  5,  5,  4,  4,  3,  3,  3,  3,  3,  4,  5,  5,  6,  7,  9, 11, 14, 14}, 
    {12, 11,  9,  8,  8,  7,  5,  4,  4,  3,  3,  3,  3,  3,  4,  4,  5,  5,  7,  8, 10, 13, 14, 14}, 
    {15, 16, 15, 12, 10,  8,  6,  5,  4,  3,  3,  3,  2,  3,  4,  5,  5,  7,  9, 11, 13, 16, 16, 16}, 
    {14, 14, 11, 10,  9,  7,  7,  5,  5,  4,  3,  3,  2,  3,  3,  4,  5,  7,  9,  9, 12, 14, 15, 15}, 
    { 9,  9,  9,  8,  7,  6,  5,  4,  3,  3,  3,  3,  3,  3,  4,  5,  6,  7,  8, 10, 11, 12, 13, 13}, 
    {14, 12, 10,  8,  6,  6,  5,  4,  3,  3,  3,  3,  3,  3,  4,  5,  6,  8,  8,  9, 11, 14, 14, 14}, 
    {13, 10,  9,  8,  6,  6,  5,  4,  4,  4,  3,  3,  2,  3,  4,  5,  6,  8,  9,  9, 11, 12, 14, 14}, 
    {16, 13, 12, 11,  9,  6,  5,  5,  4,  4,  4,  3,  2,  3,  3,  4,  5,  7,  8, 10, 14, 16, 16, 16}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}, 
    {13, 14, 14, 14, 10,  8,  7,  7,  5,  4,  3,  3,  2,  3,  3,  4,  5,  5,  7,  9, 11, 14, 14, 14}
};

const uint16_t differential_region_power_codes[MAX_NUMBER_OF_REGIONS][DIFF_REGION_POWER_LEVELS] =
{
    {     0,    0,    0,    0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,    0,    0,     0,     0,     0,     0}, 
    {     8,   38,   18,   10,   7,   6,  3,  2,  0,  1,  7,  6,  5,  4, 11, 78, 158, 318, 1278, 1279,  2552,  2553,  2554,  2555}, 
    {    36,    8,    3,    5,   0,   1,  7,  6,  4,  3,  2,  5,  3,  4,  5, 19,  74, 150,  302, 1213,  1214,  1215,  2424,  2425}, 
    {  2582,  644,  160,   41,   5,  11,  7,  5,  4,  1,  0,  6,  4,  7,  3,  6,   4,  21,   81,  323,  1290,  5167, 10332, 10333}, 
    {  2940,  366,  181,  180,  47,  46, 27, 10,  8,  5,  1,  0,  3,  7,  4,  9,  12,  26,   44,  182,   734,  2941,  2942,  2943}, 
    {  3982, 7967,  994,  249,  63,  26, 19, 18, 14,  8,  6,  1,  0,  2,  5,  7,  12,  30,   27,  125,   496,  1990, 15932, 15933}, 
    {  3254, 1626,  407,  206, 202, 100, 30, 14,  3,  5,  3,  0,  2,  4,  2, 13,  24,  31,  102,  207,   812,  6511, 13020, 13021}, 
    {  1110, 2216, 1111,  139,  35,   9,  3, 20, 11,  4,  2,  1,  3,  3,  1,  0,  21,   5,   16,   68,   276,  2217,  2218,  2219}, 
    {  1013, 1014,  127,   62,  29,   6,  4, 16,  0,  1,  3,  2,  3,  1,  5,  9,  17,   5,   28,   30,   252,  1015,  2024,  2025}, 
    {   381,  380,  372,  191,  94,  44, 16, 10,  7,  3,  1,  0,  2,  6,  9, 17,  45,  92,  187,  746,  1494,  2991,  5980,  5981}, 
    {  3036,  758,  188,   45,  43,  10,  4,  3,  6,  4,  2,  0,  3,  7, 11, 20,  42,  44,   46,   95,   378,  3037,  3038,  3039}, 
    {   751,   92,   45,   20,  26,   4, 12,  7,  4,  0,  4,  1,  3,  5,  5,  3,  27,  21,   44,   47,   186,   374,  1500,  1501}, 
    {45572U, 5697, 2849, 1425, 357,  45, 23,  6, 10,  7,  2,  2,  3,  0,  4,  6,   7,  88,  179,  713, 11392, 45573U, 45574U, 45575U}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}, 
    {  2511, 5016, 5018, 5017, 312,  79, 38, 36, 30, 14,  6,  0,  2,  1,  3,  5,   8,  31,   37,  157,   626,  5019,  5020,  5021}
};

const int16_t differential_region_power_decoder_tree[MAX_NUMBER_OF_REGIONS][DIFF_REGION_POWER_LEVELS - 1][2] =
{
    {{  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}, {  0,  0}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {  7,  8}, {  9, 10}, { 11,-12}, {-11,-10}, { -8, -9}, { -7, -6}, {-13, 12}, { -5, -4}, {  0, 13}, { -3,-14}, { -2, 14}, { -1, 15}, {-15, 16}, {-16, 17}, {-17, 18}, { 19, 20}, { 21, 22}, {-18,-19}, {-20,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {  7,  8}, {-10, -9}, { -8,-11}, { -7, -6}, {  9, -5}, { 10,-12}, { -4, 11}, {-13, -3}, { 12, -2}, { 13,-14}, { -1, 14}, { 15,-15}, {  0, 16}, {-16, 17}, {-17, 18}, {-18, 19}, { 20, 21}, { 22,-19}, {-20,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {  7,  8}, {  9, 10}, {-12, 11}, {-11,-13}, {-10, -9}, { 12,-14}, { -8, -7}, {-15, -6}, { 13, -5}, {-16, -4}, { 14,-17}, { 15, -3}, { 16,-18}, { -2, 17}, { 18,-19}, { -1, 19}, {-20, 20}, {  0, 21}, { 22,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {-11,-10}, {  7,-12}, {  8, -9}, {  9,-13}, {-14, 10}, { -8,-15}, {-16, 11}, { -7, 12}, {-17, -6}, { 13, 14}, {-18, 15}, { -5, -4}, { 16, 17}, { -3, -2}, {-19, 18}, { -1, 19}, {-20, 20}, { 21, 22}, {  0,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {-12,-11}, {-13,  7}, {  8,-14}, {-10,  9}, { 10,-15}, { -9, 11}, { -8, 12}, {-16, 13}, { -7, -6}, {-17, 14}, { -5,-18}, { 15, -4}, { 16,-19}, { 17, -3}, {-20, 18}, { -2, 19}, {-21, 20}, {  0, 21}, { 22, -1}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {-11,  7}, {-12,-10}, {-13, -9}, {  8,  9}, {-14, -8}, { 10,-15}, { -7, 11}, {-16, 12}, { -6,-17}, { 13, 14}, { -5, 15}, {-18, 16}, { -4, 17}, { -3,-19}, { 18, -2}, {-20, 19}, { -1, 20}, {  0, 21}, { 22,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,-12}, {  6,-11}, {-10,-13}, { -9,  7}, {  8,-14}, {  9, -8}, {-15, 10}, { -7,-16}, { 11, -6}, { 12,-17}, { 13, -5}, {-18, 14}, { 15, -4}, {-19, 16}, { 17, -3}, {-20, 18}, { 19, 20}, { 21, 22}, {  0, -2}, { -1,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,-12}, {  6,-13}, {-11,-10}, {  7,-14}, {  8, -9}, {  9,-15}, { -8, 10}, { -7,-16}, { 11, 12}, { -6,-17}, { -5, 13}, { 14, 15}, {-18, -4}, {-19, 16}, { -3, 17}, { 18, -2}, {-20, 19}, { 20, 21}, { 22,  0}, { -1,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {-11,-10}, {-12, -9}, {  7,  8}, {-13, -8}, {  9,-14}, { -7, 10}, { -6,-15}, { 11, 12}, { -5,-16}, { 13, 14}, {-17, 15}, { -4, 16}, { 17,-18}, { 18, -3}, { -2, 19}, { -1,  0}, {-19, 20}, {-20, 21}, { 22,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,  6}, {-11,  7}, {-10,-12}, { -9,  8}, { -8,-13}, {  9, -7}, { 10,-14}, { -6, 11}, {-15, 12}, { -5, 13}, {-16, -4}, { 14, 15}, {-17, -3}, {-18, 16}, { 17,-19}, { -2, 18}, {-20, 19}, { -1, 20}, { 21, 22}, {  0,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,-12}, {  6,-11}, {  7,  8}, {-10,-13}, { -9,  9}, { -8,-14}, { 10, -7}, { 11,-15}, { -6, 12}, { -5, 13}, { -4,-16}, { 14, 15}, { -3,-17}, { 16, 17}, {-18, -2}, { 18,-19}, { -1, 19}, {-20, 20}, {-21, 21}, { 22,  0}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {  5,-12}, {-13,  6}, {-11,  7}, {-14,  8}, {-10,  9}, {-15, -9}, { -8, 10}, { -7,-16}, { 11, -6}, { 12, -5}, {-17, 13}, { 14,-18}, { 15, -4}, { 16,-19}, { 17, -3}, { 18, -2}, { 19, -1}, {-20, 20}, { 21, 22}, {  0,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}},
    {{  1,  2}, {  3,  4}, {-12,  5}, {-11,-13}, {  6,-14}, {-10,  7}, {  8,-15}, { -9,  9}, {-16, 10}, { -8,-17}, { 11, 12}, { -7,-18}, { -6, 13}, { 14, -5}, { 15,-19}, { -4, 16}, {-20, 17}, { 18, 19}, { 20, 21}, { 22,  0}, { -1, -3}, { -2,-21}, {-22,-23}}
};

#if defined(G722_1_USE_FIXED_POINT)
const int16_t mlt_quant_centroid[NUM_CATEGORIES][MAX_NUM_BINS] =
{
    {     0,   1606,   3119,   4586,   6049,   7502,   8941,  10406,  11851,  13292,  14736,  16146,  17566,  19351,      0,      0},
    {     0,   2229,   4341,   6401,   8471,  10531,  12583,  14588,  16673,  18924,      0,      0,      0,      0,      0,      0},
    {     0,   3055,   5998,   8929,  11806,  14680,  17680,      0,      0,      0,      0,      0,      0,      0,      0,      0},
    {     0,   4121,   8192,  12259,  16322,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0},  
    {     0,   5413,  11071,  16315,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0},
    {     0,   6785,  14300,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0},
    {     0,   8044,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0},
    {     0,   8019,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0}
};
#else
const float mlt_quant_centroid[NUM_CATEGORIES - 1][MAX_NUM_BINS] =
{
    {  0.0f, 0.392f, 0.761f, 1.120f, 1.477f, 1.832f, 2.183f, 2.541f, 2.893f, 3.245f, 3.598f, 3.942f, 4.288f, 4.724f,   0.0f,   0.0f},
    {  0.0f, 0.544f, 1.060f, 1.563f, 2.068f, 2.571f, 3.072f, 3.562f, 4.070f, 4.620f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f},
    {  0.0f, 0.746f, 1.464f, 2.180f, 2.882f, 3.584f, 4.316f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f},
    {  0.0f, 1.006f, 2.000f, 2.993f, 3.985f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f},
    {  0.0f, 1.321f, 2.703f, 3.983f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f},
    {  0.0f, 1.657f, 3.491f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f},
    {  0.0f, 1.964f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f,   0.0f}
};
#endif

const int16_t expected_bits_table[NUM_CATEGORIES] =
{
    52, 47, 43, 37, 29, 22, 16,  0
};

const int16_t mlt_sqvh_bitcount_category_0[196] =
{
     1,  4,  6,  6,  7,  7,  8,  8,  8,  9,  9, 10, 11, 11,  4,  5, 
     6,  7,  7,  8,  8,  9,  9,  9,  9, 10, 11, 11,  5,  6,  7,  8, 
     8,  9,  9,  9,  9, 10, 10, 10, 11, 12,  6,  7,  8,  9,  9,  9, 
     9, 10, 10, 10, 10, 11, 12, 13,  7,  7,  8,  9,  9,  9, 10, 10, 
    10, 10, 11, 11, 12, 13,  8,  8,  9,  9,  9, 10, 10, 10, 10, 11, 
    11, 12, 13, 14,  8,  8,  9,  9, 10, 10, 11, 11, 11, 12, 12, 13, 
    13, 15,  8,  8,  9,  9, 10, 10, 11, 11, 11, 12, 12, 13, 14, 15, 
     9,  9,  9, 10, 10, 10, 11, 11, 12, 13, 12, 14, 15, 16,  9,  9, 
    10, 10, 10, 10, 11, 12, 12, 14, 14, 16, 16, 16,  9,  9, 10, 10, 
    11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 10, 10, 10, 11, 11, 12, 
    12, 13, 15, 15, 16, 14, 15, 15, 11, 11, 11, 12, 13, 13, 13, 15, 
    16, 16, 16, 16, 14, 15, 11, 11, 12, 13, 13, 14, 15, 16, 16, 16, 
    16, 16, 16, 14
};

const uint16_t mlt_sqvh_code_category_0[196] =
{
       1,     2,     1,    24,    14,    51,     9,    68,   110,    26,   218,    54,   154,   761,     3,    10, 
      22,     8,    58,    22,    71,    16,    30,    50,   213,    75,    94,   632,    15,    18,    52,    23, 
     107,     5,    54,    63,   239,    46,   276,   271,   851,   252,    28,    10,    12,     1,    22,   133, 
     191,    55,   105,   278,   317,   554,   310,   276,    32,    50,    94,    20,   187,   219,    13,   268, 
     473,   445,   145,   849,  1277,   623,     1,    14,     0,    55,   238,   121,   120,   269,   318,   530, 
     639,  1117,   509,   556,    24,    78,    51,   153,    62,   308,    16,    25,    68,  1058,   428,   277, 
    2233,  1114,    92,   108,   141,   223,   270,   381,    24,   212,   760,    35,  1063,   279,  1717,  3439, 
       7,    21,   152,    73,   309,   310,    95,   944,  1890,  2232,  1891,  5107, 10213,  4981,    61,    62, 
       9,    79,   474,   475,   848,  1059,  1056,  1716,   139,  4978,  4983,  4983,   140,   186,    76,   444, 
     144,   633,  1057,   838,  2237,  4472,  4473, 10212, 10212,  4983,    74,    78,   311,   213,   850,  1062, 
    1119,   508,   276,   277,  4982,  4473, 10212, 10212,   208,    70,   555,   418,    68,   510,  2552,  1115, 
    4980,  4979,  4982,  4982,  4473, 10212,   215,    71,   253,   511,   839,  1718,  2488,  6876,  6877,  4979, 
    4979,  4982,  4982,  4473
};

const int16_t mlt_sqvh_bitcount_category_1[100] =
{
     1,  4,  5,  6,  7,  8,  8,  9, 10, 10,  4,  5,  6,  7,  7,  8, 
     8,  9,  9, 11,  5,  5,  6,  7,  8,  8,  9,  9, 10, 11,  6,  6, 
     7,  8,  8,  9,  9, 10, 11, 12,  7,  7,  8,  8,  9,  9, 10, 11, 
    11, 13,  8,  8,  8,  9,  9, 10, 10, 11, 12, 14,  8,  8,  8,  9, 
    10, 11, 11, 12, 13, 15,  9,  9,  9, 10, 11, 12, 12, 14, 14, 14, 
     9,  9,  9, 10, 11, 12, 14, 16, 14, 14, 10, 10, 11, 12, 13, 14, 
    16, 16, 16, 14
};

const uint16_t mlt_sqvh_code_category_1[100] =
{
        1,    2,   11,   27,   31,    9,  120,   31,  275,  310,    1,    0,   12,    5,   33,   54,
      102,  111,  246,  448,   10,   14,   31,   39,   59,  100,  114,  202,  485,  969,   24,   26,
       36,   52,  103,   30,  120,  242,   69, 1244,   35,   32,   14,   61,  113,  117,  233,  486,
      487, 2491,   13,   12,   69,  110,  149,   35,  495,  449, 1978, 7751,   76,   75,  122,  136,
      213,   68,  623,  930, 3959, 9961,  115,   16,  107,  225,  424,  850, 1936, 7916, 4981, 4981,
      148,  154,  243,  407,  988,  851, 7750,19920, 7916, 4981,  406,  274,  464,  931, 3874, 7917,
    19921,19920,19920, 7916
};

const int16_t mlt_sqvh_bitcount_category_2[49] =
{
     1,  4,  5,  7,  8,  9, 10,  3,  4,  5,  7,  8,  9, 10,  5,  5,
     6,  7,  8, 10, 10,  7,  6,  7,  8,  9, 10, 12,  8,  8,  8,  9,
    10, 12, 14,  8,  9,  9, 10, 11, 15, 16,  9, 10, 11, 12, 13, 16,
    15
};

const uint16_t mlt_sqvh_code_category_2[49] =
{
        1,     0,    10,    11,    28,    62,   363,     3,     2,     9,     8,    24,    53,   352,     7,     8, 
       13,    25,    89,    74,   355,    10,    23,    24,    29,    55,   354,  1449,    25,    19,    30,    52, 
      108,   438,  5793,    91,    36,    63,   353,   725, 11584, 23170,   180,    75,   218,   439,  2897, 23171, 
    11584
};

const int16_t mlt_sqvh_bitcount_category_3[625] =
{
     2,  4,  6,  8, 10,  5,  5,  6,  8, 10,  7,  8,  8, 10, 12,  9, 
     9, 10, 12, 15, 10, 11, 13, 16, 16,  5,  6,  8, 10, 11,  5,  6, 
     8, 10, 12,  7,  7,  8, 10, 13,  9,  9, 10, 12, 15, 12, 11, 13, 
    16, 16,  7,  9, 10, 12, 15,  7,  8, 10, 12, 13,  9,  9, 11, 13, 
    16, 11, 11, 12, 14, 16, 12, 12, 14, 16, 14,  9, 11, 12, 16, 16, 
     9, 10, 13, 15, 16, 10, 11, 12, 16, 16, 13, 13, 16, 16, 16, 16, 
    16, 15, 16, 16, 11, 13, 16, 16, 15, 11, 13, 15, 16, 16, 13, 13, 
    16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,  4,  6,  8, 
    10, 13,  6,  6,  8, 10, 13,  9,  8, 10, 12, 16, 10, 10, 11, 15, 
    16, 13, 12, 14, 16, 16,  5,  6,  8, 11, 13,  6,  6,  8, 10, 13, 
     8,  8,  9, 11, 14, 10, 10, 12, 12, 16, 13, 12, 13, 15, 16,  7, 
     8,  9, 12, 16,  7,  8, 10, 12, 14,  9,  9, 10, 13, 16, 11, 10, 
    12, 15, 16, 13, 13, 16, 16, 15,  9, 11, 13, 16, 16,  9, 10, 12, 
    15, 16, 10, 11, 13, 16, 16, 13, 12, 16, 16, 16, 16, 16, 16, 16, 
    16, 11, 13, 16, 16, 16, 11, 13, 16, 16, 16, 12, 13, 15, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  6,  8, 11, 13, 16,  8, 
     8, 10, 12, 16, 11, 10, 11, 13, 16, 12, 13, 13, 15, 16, 16, 16, 
    14, 16, 15,  6,  8, 10, 13, 16,  8,  8, 10, 12, 16, 10, 10, 11, 
    13, 16, 13, 12, 13, 16, 16, 14, 14, 14, 16, 16,  8,  9, 11, 13, 
    16,  8,  9, 11, 16, 14, 10, 10, 12, 15, 16, 12, 12, 13, 16, 16, 
    15, 16, 16, 16, 16, 10, 12, 15, 16, 16, 10, 12, 12, 14, 16, 12, 
    12, 13, 16, 16, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 12, 15, 
    15, 16, 16, 13, 13, 16, 16, 14, 14, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 14, 15, 16, 16, 16,  8, 10, 13, 15, 16, 10, 11, 13, 16, 
    16, 13, 13, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
     8, 10, 11, 15, 16,  9, 10, 12, 16, 16, 12, 12, 15, 16, 16, 16, 
    14, 16, 16, 16, 16, 16, 16, 16, 16,  9, 11, 14, 16, 16, 10, 11, 
    13, 16, 16, 14, 13, 14, 16, 16, 16, 15, 15, 16, 16, 16, 16, 16, 
    16, 16, 11, 13, 16, 16, 16, 11, 13, 15, 16, 16, 13, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 
    14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 16,  9, 13, 16, 16, 16, 11, 13, 16, 16, 16, 14, 15, 
    16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,  9, 13, 15, 
    15, 16, 12, 13, 14, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 11, 13, 15, 16, 16, 12, 14, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 
    16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16
};

const uint16_t mlt_sqvh_code_category_3[625] =
{
       3,    8,   46,  145,  228,    4,    8,   47,   28,  455,   89,    2,  180,    5, 1335,  250,
      12,  644, 1311,  139,  729,  251,  870, 2172, 2211,    5,   23,  112,  334, 1469,   21,    3,
       5,  111, 2014,   88,   79,  152,  124, 2685,  297,   48,  110, 1310,  149,  501, 1231,  153,
    2267, 2569,   57,   13,  653, 2587,  143,   75,  124,  118, 2611, 5242,   61,   50,  253, 3633,
    2216,  476,   39,   57, 1926, 2236, 2586, 1329, 1920, 2566, 1926,  296,  233, 2590, 2240, 2217,
     253,  613,  867,  144,  318,  614,  252, 2589, 2242, 2218,  872,  866, 2187, 2296, 2155, 2568,
    2227,  150, 2567, 2296,  199, 2686, 2160, 2290,19145,  232, 2680,  128, 2192, 2212, 2684,  793,
    2281, 2223, 2242, 1934, 2165, 2146, 2291, 2296, 2222, 2189, 2187, 2296, 2296,    6,    4,   82,
     725, 3632,   15,   21,   56,  599,  148,    3,  162,   42,  411, 2301,  735,  654,  930,  137,
    2586,  869, 1334, 1931, 2300, 2213,    9,   22,  146, 1290, 5240,    5,   12,   53,  630,  875,
      80,    9,    8,   86, 2002,  210,  117,   56, 2019, 2162,  146,  397,  868,  131, 2151,   77,
     160,  365, 2610, 2252,   59,   54,   41, 2591, 1928,  226,   14,  121, 5792, 2295, 1197,  728,
     408,  130, 2157, 3635,  155, 2573, 2587,  130,  314,   64,  144, 2173, 2176,  115,   30,  409,
     153, 2590,  631,   26, 4787, 2221, 2174, 2683, 1863, 2572,  319, 2150, 2177, 2194, 2571, 2257,
     319,   65,  145, 2251, 2156, 2161,  909,  864, 2193, 2197, 2246, 2588, 5797,  156, 2258, 2221,
    2158, 2199, 2214, 2152,  319, 2188, 2264, 2572,  319,  319,   30,  117,  219,  865, 2263,  147,
     127,  239,  410, 2247,   27,  324, 1468, 2681, 2180, 1328, 5241,  147,  142, 2237, 2241, 2245,
    1921, 2262,  142,   41,   11,  505, 2682, 2591,    0,   26,  229, 2015, 2577,  464,   98,   87,
    5243, 2166,  149, 2016, 5244, 2190, 2198, 9573,11598,11599, 2235, 2190,  144,  298, 1004, 5245,
    2277,  156,  104,  254, 2560, 1922,  612,  325, 2017,  129, 2588, 2608, 1330,  871, 2144, 2145,
     132, 2147, 2148, 2149, 2144,  119, 1331,  133, 2153, 2154,  211,   58, 2609, 1923, 2159,  510,
     163, 5246, 2163, 2164, 1924,  134, 2167, 2168, 2168, 2169, 2170, 2171, 2168, 2168, 1332,  135,
     136, 2175, 2153,  150,  873, 2178, 2179, 1923, 1925, 2181, 2182, 2183, 2163, 2184, 2185, 2186,
    2168, 2168, 1924,  134, 2167, 2168, 2168,   58,  326, 2687,  138, 2191,   31,   66,  874, 2195,
    2196,  151,  152, 1927, 2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 2209, 2210, 2205,
      55,  103, 1230,  140, 2215,  118,   15, 1333, 2219, 2220, 2018,  511,  141, 2224, 2225, 2226,
    1929, 2228, 2229, 2230, 2231, 2232, 2233, 2234, 2229,  366, 1005, 1930, 2238, 2239,   12, 1006,
    5247, 2243, 2244, 1932, 3634, 1933, 2248, 2249, 2250,  145,  146, 2253, 2253, 2254, 2255, 2256,
    2253, 2253, 1291, 5793, 2259, 2260, 2261,  477, 5794,  147, 2265, 2266, 5795, 2268, 2269, 2270,
    2270, 2271, 2272, 2273, 2274, 2274, 2275, 2276, 2273, 2274, 2274,  148, 2278, 2279, 2280, 2260,
    1935, 2282, 2283, 2284, 2265, 2285, 2286, 2287, 2270, 2270, 2288, 2289, 2273, 2274, 2274, 2271,
    2272, 2273, 2274, 2274,  233, 5796, 2292, 2293, 2294, 1292, 3724, 2297, 2298, 2299, 2000,  151,
    2302, 2303, 2200,  152, 2561, 2562, 2563, 2205, 2564, 2565, 2204, 2205, 2205,  363,  154,  154,
     155, 2570,   59, 3725, 2001, 2574, 2575, 2576,  157, 2578, 2579, 2224, 2580, 2581, 2582, 2583,
    2229, 2584, 2585, 2228, 2229, 2229,  654, 5798,  158, 2589, 2238, 2392, 2003, 2592, 2593, 2243,
    2594, 2595, 2596, 2597, 2248, 2598, 2599, 2600, 2253, 2253, 2250,  145,  146, 2253, 2253, 2601,
    2602, 2603, 2604, 2260, 2605, 2606, 2607, 6336, 2265, 6337, 6338, 6339, 2270, 2270, 6340, 6341,
    2273, 2274, 2274, 2271, 2272, 2273, 2274, 2274, 6342, 6343, 2259, 2260, 2260,38288U,38289U,  147,
    2265, 2265, 5795, 2268, 2269, 2270, 2270, 2271, 2272, 2273, 2274, 2274, 2271, 2272, 2273, 2274,
    2274
};

const int16_t mlt_sqvh_bitcount_category_4[256] =
{
     2,  4,  7, 10,  4,  5,  7, 10,  7,  8, 10, 14, 11, 11, 15, 15, 
     4,  5,  9, 12,  5,  5,  8, 12,  8,  7, 10, 15, 11, 11, 15, 15, 
     7,  9, 12, 15,  8,  8, 12, 15, 10, 10, 13, 15, 14, 14, 15, 13, 
    11, 13, 15, 15, 11, 13, 15, 15, 14, 15, 15, 13, 15, 15, 13, 13, 
     4,  5,  9, 13,  5,  6,  9, 13,  9,  9, 11, 15, 14, 13, 15, 15, 
     4,  6,  9, 12,  5,  6,  9, 13,  9,  8, 11, 15, 13, 12, 15, 15, 
     7,  9, 12, 15,  7,  8, 11, 15, 10, 10, 14, 15, 14, 15, 15, 14, 
    10, 12, 15, 15, 11, 13, 15, 15, 15, 15, 15, 14, 15, 15, 14, 14, 
     6,  9, 13, 14,  8,  9, 12, 15, 12, 12, 15, 15, 15, 15, 15, 15, 
     7,  9, 13, 15,  8,  9, 12, 15, 11, 12, 15, 15, 15, 15, 15, 15, 
     9, 11, 15, 15,  9, 11, 15, 15, 14, 14, 15, 15, 15, 15, 15, 15, 
    14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14, 14, 15, 15, 
     9, 12, 15, 15, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
    10, 12, 15, 15, 12, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
    14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 15, 15, 
    15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 15, 15, 14, 14, 15, 15
};

const uint16_t mlt_sqvh_code_category_4[256] =
{
        1,     2,     4,   572,    10,     0,    69,   712,    91,    10,    46,  9182,  1426,  1430, 30172, 30194, 
        9,    28,    22,  2258,    16,    25,   142,  2179,    15,   111,   719,  1521,  1131,  1437,  1520, 30196, 
       88,   283,  3803, 30193,    13,   236,  2856, 30166,   545,   951,  5709,  1522,  3241,  9180, 30179,  5709, 
     1088,  4356, 30410, 30175,  1146,   377, 30162, 30163,  8715, 30176, 30165,  5709, 30197, 30184,  5709,  5709, 
        1,    23,    28,  5710,    26,    14,    29,  7538,   102,   103,  1429,  1524,  3237,  7060, 30401, 30201, 
       15,    13,   470,  3768,    24,    15,   281,  5747,    24,   181,  1128, 30206,  5711,  3531, 30156, 30158, 
      116,   100,  2260, 30187,   119,   234,  1764, 30171,   716,   883,  9183, 30164,  3236,  1528, 30180,  9183, 
      885,  2870,  1532, 30160,  1431,  5708, 30192, 30205, 30402, 30168, 30173,  9183, 30157, 30161,  9183,  9183, 
       54,    25,  1621, 15211,   180,   287,  2261, 30198,   808,   811, 30411, 30413, 30414, 22986, 22987, 30411, 
       24,   273,   376, 30159,   137,   280,  2871,  1523,  1768,  2259,  1525, 30167,  1526, 30169, 30170,  1525, 
      443,  1434,  1527, 30174,   474,  1769, 30177, 30178,  3238,  3239, 30181, 30181, 30182, 30183, 30181, 30181, 
     3240, 30185, 30186,  1527,  9181, 30188, 30189, 30177, 30190, 30191, 30181, 30181,  3238,  3239, 30181, 30181, 
      440,  2857,  1529, 30195,  2294,  7061,  1530, 30199, 30200,  1531, 30202, 30411, 30203, 30204, 30411, 30411, 
      203,  2872, 30207, 30400,   189, 11492, 30403, 30404, 30405, 30406, 30407,  1525, 30408, 30409,  1525,  1525, 
     8714,  1533, 30412,  1527,  1534,  1535, 30415, 30177, 30416, 30417, 30181, 30181,  3238,  3239, 30181, 30181, 
    30418, 30419,  1527,  1527, 30420, 30421, 30177, 30177,  3238,  3239, 30181, 30181,  3238,  3239, 30181, 30181
};

const int16_t mlt_sqvh_bitcount_category_5[243] =
{
     2,  4,  8,  4,  5,  9,  9, 10, 14,  4,  6, 11,  5,  6, 12, 10, 
    11, 15,  9, 11, 15, 10, 13, 15, 14, 15,  6,  4,  6, 12,  6,  7, 
    12, 12, 12, 15,  5,  7, 13,  6,  7, 13, 12, 13, 15, 10, 12, 15, 
    11, 13, 15, 15, 15,  7,  8, 13, 15, 11, 12, 15, 15, 15,  7, 10, 
    13, 15, 12, 15, 15, 15, 15,  7, 15, 15,  7, 15, 15,  7,  6,  7, 
     7,  4,  5, 11,  5,  7, 12, 11, 12, 15,  6,  7, 13,  7,  8, 14, 
    12, 14, 15, 11, 13, 15, 12, 13, 15, 15, 15,  8,  5,  6, 13,  7, 
     8, 15, 12, 14, 15,  6,  8, 14,  7,  8, 15, 14, 15, 15, 12, 12, 
    15, 12, 13, 15, 15, 15,  8,  9, 13, 15, 12, 13, 15, 15, 15,  8, 
    11, 13, 15, 13, 13, 15, 15, 15,  8, 14, 15,  8, 15, 15,  8,  7, 
     8,  8,  8, 10, 15, 11, 12, 15, 15, 15,  7, 10, 12, 15, 12, 13, 
    15, 15, 15,  8, 14, 15,  7, 15, 15,  8,  7,  8,  8,  8, 12, 15, 
    12, 13, 15, 15, 15,  8, 11, 13, 15, 13, 15, 15, 15, 15,  8, 15, 
    15,  8, 15, 15,  8,  7,  8,  8, 14, 15,  6, 15, 15,  8,  7,  8, 
     8, 15, 15,  8, 15, 15,  8,  7,  8,  8,  6,  8,  8,  7,  8,  8, 
     7,  8,  8
};

const uint16_t mlt_sqvh_code_category_5[243] =
{
        0,     5,   220,    10,    16,   443,   390,   391, 14333,    11,    26,  1566,    26,    54,  3135,   508, 
     1558, 28581,   255,  1782, 28599,   885,  6208, 28578, 14335, 28579,    54,     9,    35,  3129,    27,    68, 
     3537,  1562,  3568, 28610,    25,    62,  4078,    58,   118,  7763,  3107,  7758, 28563,   778,  3131, 28598, 
      780,  7123, 28630, 28593, 28586,   118,   243,  6210, 28614,  1018,  3567, 28601, 28611, 28570,    68,   388, 
     6256, 28619,  1559, 28562, 28606, 28565, 28591,   118, 28594, 28571,    62, 28618, 28590,   118,    58,   118, 
      118,     4,    28,  1781,    31,    60,  3134,  1938,  3882, 28574,    25,    96,  7757,    49,   126, 14244, 
     3883, 14334, 28613,  1769,  4077, 28602,  3106,  7756, 28582, 28621, 28566,   126,    14,    61,  4079,    61, 
      138, 28491,  3536,  8153, 28573,    49,    96, 12442,   119,   240, 28490, 12443, 28560, 28561,  3111,  3580, 
    28564,  3130,  7759, 28567, 28568, 28569,   240,   444,  6209, 28572,  3569,  6211, 28575, 28576, 28577,   138, 
      778,  7760, 28580,  7761,  7762, 28583, 28584, 28585,   240, 14319, 28587,    96, 28588, 28589,   240,   119, 
      240,   240,   139,   968, 28592,  1554,  3581, 28595, 28596, 28597,    60,   971,  3560, 28600,  3582,  7132, 
    28603, 28604, 28605,   126, 14332, 28607,    96, 28608, 28609,   126,    49,   126,   126,   241,  1558, 28612, 
     1563,  6257, 28615, 28616, 28617,   138,  1559,  7133, 28620,  6220, 28622, 28623, 28624, 28625,   240, 28626, 
    28627,    96, 28628, 28629,   240,   119,   240,   240,  8152, 28631,    61, 28632, 28633,   138,    61,   138, 
      138, 28634, 28635,    96, 28636, 28637,   240,   119,   240,   240,    49,    96,    96,   119,   240,   240, 
      119,   240,   240
};

const int16_t mlt_sqvh_bitcount_category_6[32] =
{
    1,  4,  4,  6,  4,  6,  6,  8,  4,  6,  6,  8,  6,  9,  8, 10, 
    4,  6,  7,  8,  6,  9,  8, 11,  6,  9,  8, 10,  8, 10,  9, 11
};

const uint16_t mlt_sqvh_code_category_6[32] =
{
    1,    2,    4,    2,    5,   29,   24,  101,    3,   31,   28,  105,    3,    5,  102,  424,
    1,   30,    0,  107,   27,  200,  103,  806,    1,    4,  104,  402,    3,  425,  213,  807
};

const int16_t *table_of_bitcount_tables[NUM_CATEGORIES - 1] =
{
    mlt_sqvh_bitcount_category_0,
    mlt_sqvh_bitcount_category_1,
    mlt_sqvh_bitcount_category_2,
    mlt_sqvh_bitcount_category_3,
    mlt_sqvh_bitcount_category_4,
    mlt_sqvh_bitcount_category_5,
    mlt_sqvh_bitcount_category_6
};

const uint16_t *table_of_code_tables[NUM_CATEGORIES - 1] =
{
    mlt_sqvh_code_category_0,
    mlt_sqvh_code_category_1,
    mlt_sqvh_code_category_2,
    mlt_sqvh_code_category_3,
    mlt_sqvh_code_category_4,
    mlt_sqvh_code_category_5,
    mlt_sqvh_code_category_6
};

const int16_t mlt_decoder_tree_category_0[180][2] =
{
    {   1,   0}, {   2,   3}, {   4,   5}, {   6,   7}, {   8,   9}, {  -1, -14}, {  10,  11}, {  12,  13},
    {  14,  15}, {  16,  17}, {  18,  19}, { -15,  20}, {  21,  22}, {  23, -28}, {  24,  -2}, {  25,  26},
    {  27,  28}, {  29,  30}, {  31,  32}, { -29,  33}, { -16,  34}, {  -3,  35}, {  36,  37}, { -42,  38},
    {  39,  40}, {  41,  42}, {  43,  44}, { -17,  45}, { -43,  46}, {  47,  48}, {  -4,  49}, { -56,  50},
    {  51,  52}, {  53,  54}, {  55,  56}, { -57,  -5}, { -30,  57}, {  58,  59}, { -18,  60}, {  61, -70},
    {  62,  63}, {  64,  -6}, {  65,  66}, { -44,  67}, { -71,  68}, {  69,  70}, { -19, -31}, { -84,  71},
    {  72,  73}, {  74,  75}, {  76,  77}, {  -7,  78}, {  79, -20}, {  80,  81}, { -85,  82}, { -98,  83},
    { -58,  84}, {  85, -32}, { -99,  86}, {  -8,  87}, {  88,  89}, { -72, -45}, {  90, -33}, {  91,-112},
    { -21,  92}, { -59,-113}, { -46,  93}, {  -9,  94}, { -22,  95}, {  96,  97}, {  98,  99}, { -23, -86},
    { 100, 101}, { -34, -73}, { 102,-126}, {-127, -35}, { 103, -47}, { 104, 105}, { 106, 107}, {-140,-100},
    {-114, -87}, { 108, 109}, { 110, 111}, {-141, -60}, { 112, -48}, { 113, -24}, { -10, -61}, { 114,-101},
    { 115, 116}, { -74, -36}, { 117,-128}, { 118, -62}, { 119, 120}, { -37, 121}, { -11, -49}, { -88, 122},
    { 123,-115}, {-154, -25}, {-142, 124}, {-155,-129}, { 125, -50}, { 126, 127}, { -76, -75}, { 128, 129},
    { -63, -77}, {-102, -39}, { -38, 130}, { -51, 131}, { -89,-116}, {-117,-156}, { 132, -52}, { -78, 133},
    { 134,-103}, { 135, 136}, {-143, -65}, { 137, -64}, {-130,-131}, { -90, 138}, {-104, -91}, { -92, 139},
    {-169,-183}, { -26,-118}, { 140, 141}, {-144, -66}, { -12, 142}, {-168, 143}, {-105,-157}, { 144,-182},
    { 145, 146}, { -79, 147}, { -53,-170}, { 148, 149}, { -27,-145}, { 150, -80}, {-106, -13}, {-132, -67},
    {-158, -40}, {-119, 151}, { 152,-107}, { 153, 154}, { -41,-184}, { 155, 156}, { -54, 157}, {-171, 158},
    { -94, 159}, {-134,-146}, { -93,-133}, {-159,-108}, { 160, -81}, { 161,-160}, { 162, -68}, {-120,-122},
    {-172, 163}, { -55, -95}, { 164,-109}, {-161, -82}, {-173,-185}, { 165, -69}, {-147,-186}, { 166, 167},
    {-121, -96}, { 168,-148}, {-174, 169}, { 170,-136}, { -83, 171}, { 172, 173}, {-135,-110}, {-187, 174},
    {-149,-150}, { 175,-123}, {-162,-163}, { -97,-175}, {-188, 176}, { 177, 178}, { 179,-111}, {-151,-124},
    {-137,-177}, {-176,-125}, {-164,-138}, {-189,-190},
};

const int16_t mlt_decoder_tree_category_1[93][2] =
{
    {   1,   0}, {   2,   3}, {   4,   5}, {   6,   7}, {   8, -10}, {  -1,   9}, {  10,  11}, {  12,  13},
    { -11,  14}, {  15,  16}, {  17,  18}, { -20,  -2}, {  19,  20}, { -21,  21}, {  22,  23}, { -12,  24},
    {  25,  26}, {  27,  28}, {  29,  30}, { -30,  31}, { -31,  -3}, {  32, -22}, {  33, -13}, {  34,  35},
    {  36,  37}, {  38,  39}, {  40,  -4}, { -41, -14}, {  41, -40}, { -32,  42}, {  43, -23}, {  44,  45},
    {  46,  47}, {  48,  -5}, { -51, -50}, { -42,  49}, { -33,  50}, { -15,  51}, {  52,  53}, {  54, -24},
    {  55, -43}, {  56, -52}, {  57, -61}, { -60,  58}, { -25,  59}, { -16, -34}, {  -6,  60}, { -62,  61},
    { -71,  62}, { -35,  -7}, {  63, -72}, { -53, -17}, {  64, -44}, { -26, -70}, {  65, -45}, { -36,  66},
    { -63,  67}, { -80, -54}, { -81,  68}, { -27,  69}, {  70, -82}, { -18,  71}, {  72, -55}, {  73, -64},
    {  74, -73}, {  75, -46}, { -37,  76}, { -91,  -8}, {  -9,  77}, { -90, -83}, {  78, -28}, {  79, -56},
    { -65, -38}, { -74,  80}, { -19, -57}, { -92,  81}, { -47, -48}, {  82, -66}, {  83, -29}, { -84,  84},
    { -75, -85}, { -67, -93}, { -39,  85}, { -76,  86}, { -58,  87}, {  88, -49}, { -94,  89}, {  90, -68},
    {  91, -78}, { -86, -59}, { -77, -95}, {  92, -69}, { -87, -96},
};

const int16_t mlt_decoder_tree_category_2[47][2] =
{
    {   1,   0}, {   2,   3}, {   4,   5}, {   6,  -7}, {  -1,   7}, {  -8,   8}, {   9,  10}, {  11,  12},
    {  13, -14}, { -15,  -9}, {  -2,  14}, {  15,  16}, {  17,  18}, {  19, -16}, {  20, -22}, { -10,  21},
    { -21,  -3}, {  22,  23}, {  24,  25}, { -23, -17}, {  26,  27}, {  28, -29}, { -11, -28}, {  29,  30},
    {  -4, -24}, { -30,  31}, {  32, -18}, {  33, -35}, { -36,  34}, { -31, -12}, {  35, -25}, {  -5, -37},
    {  36,  37}, { -42,  38}, { -19, -43}, { -32,  39}, { -13, -38}, { -26, -20}, {  40,  -6}, { -44,  41},
    {  42, -39}, { -33, -45}, {  43, -27}, {  44, -46}, {  45, -34}, { -40,  46}, { -41, -47},
};

const int16_t mlt_decoder_tree_category_3[519][2] =
{
    {   1,   2}, {   3,   4}, {   5,   0}, {   6,   7}, {   8,   9}, {  10,  11}, {  12,  13}, {  14,  15},
    {  16,  17}, {-125,  18}, {  -1,  19}, {  20,  21}, {  22,  23}, {  24,  25}, {  -5, -25}, {  26,  27},
    {  -6,-150}, {  28,  29}, {  30,  31}, {  32,  33}, {  34, -30}, {  35,  36}, {  37,  38}, {  39, -31},
    {-126,-155}, {  40,  41}, {-156,  42}, {  43,-130}, {  44,-131}, {-151, -26}, {  45,  46}, {-250,  47},
    {  48,  49}, {  50,  51}, {  52,-275}, {  53,  54}, {  -2,  -7}, {  55,  56}, {  57,  58}, {  59,  60},
    {  61,  62}, {  63,  64}, {  65,  66}, {  67,  68}, {  69,  70}, {  71, -50}, {  72,-180}, {  73,  74},
    {  75,  76}, {  77, -55}, {  78,-175}, {  79, -36}, {  80,  81}, { -35, -10}, {  82,  83}, {-280,  84},
    { -11,  85}, {  86, -32}, {  87,  88}, {  89,-161}, {  90,-276}, {  91,  92}, {-281,  93}, {  -8,  94},
    {  95,  96}, {  97,-157}, {-181,-400}, {-132,  98}, {-375,  99}, {-160, 100}, {-127, 101}, { -27, 102},
    { 103,-251}, { -56, 104}, { 105,-256}, {-300,  -3}, {-152,-255}, { 106, 107}, { -37, 108}, {-305, 109},
    {-176, 110}, {-136, 111}, { -12, 112}, { 113, 114}, { 115,-135}, { 116, 117}, {-162, 118}, { -16, -51},
    {-186, 119}, { 120, 121}, { 122, 123}, { -41, 124}, { -61, 125}, { 126, 127}, { 128, 129}, { 130, -60},
    { 131, 132}, {-306, 133}, { 134,-205}, {-405, 135}, { 136, 137}, { 138, 139}, {-185, 140}, { 141,-500},
    { -15, 142}, { 143, -80}, { -75, -40}, {-301, 144}, { 145, 146}, {-200, 147}, { 148, 149}, { 150, 151},
    { 152,-525}, { 153,-177}, {-425, 154}, { 155, -13}, {-430, 156}, { 157,-406}, { 158, 159}, {-206,-380},
    { 160, 161}, { 162, 163}, { 164,-182}, {-137, 165}, {-286, 166}, { 167,-401}, { 168, 169}, { -42, -33},
    { 170,-166}, { -57,-325}, { 171,-187}, { -38, 172}, { 173, 174}, {-165,-330}, {  -4,-282}, { 175,-257},
    {-261,-311}, {-376, 176}, { 177, 178}, { -28, 179}, { 180,  -9}, {-285, 181}, { 182, 183}, { 184,-277},
    { 185,-133}, {-310, -81}, { -85, 186}, {-158,-210}, { -17, 187}, { 188, 189}, { 190, -52}, {-141, 191},
    { 192,-128}, {-191, -20}, { 193,-140}, { 194, 195}, {-211,-260}, { 196, 197}, { 198, 199}, { 200, -66},
    {-201,-225}, {-381, 201}, { 202, 203}, { 204, 205}, { 206, 207}, {-163,-287}, { 208,-100}, { 209, 210},
    { 211, 212}, { 213,-252}, {-105, -76}, { 214, 215}, { 216, -21}, { -86, -62}, {-307, 217}, { -65,-455},
    {-550, 218}, { 219, 220}, { 221, 222}, { 223, 224}, { 225,-230}, {-142, 226}, {-302,-426}, {-431, 227},
    { 228, 229}, { 230,-190}, {-402, -46}, {-153,-450}, {-505, 231}, { 232, 233}, { 234, 235}, { 236, 237},
    { 238, 239}, {-262, -29}, { 240, 241}, { 242, 243}, {-167, -67}, {-331,-530}, { 244, 245}, { 246, 247},
    { 248, 249}, { 250, 251}, { 252, 253}, { 254, 255}, { 256, 257}, { 258, 259}, { 260, 261}, { 262,-336},
    { 263,-171}, {-192,-207}, {-258,-138}, { 264, 265}, { 266, 267}, { 268, 269}, { 270, 271}, { 272, 273},
    { 274, -45}, {-335,-411}, { -43, -18}, {-265, -71}, {-316,-326}, {-350,-407}, {-146, -14}, { 275, 276},
    { 277, 278}, { 279, 280}, { 281,-216}, { -34,-283}, {-291,-312}, {-410,-168}, {-555, 282}, { -70, -53},
    {-235, -87}, { -77,-183}, {-315,-332}, {-178, -58}, { 283, 284}, { 285, 286}, { 287, 288}, { 289, 290},
    { 291, 292}, { 293, 294}, { 295, 296}, { 297, 298}, {-202,-226}, {-170,-267}, {-134,-290}, {-355,-385},
    {-386, -47}, {-526,-196}, { 299, 300}, { 301, 302}, { 303, 304}, { 305, 306}, { 307, 308}, { 309, 310},
    { 311, 312}, { 313, 314}, { 315, 316}, { 317, 318}, { 319, 320}, { 321, 322}, { 323, 324}, { 325,-111},
    {-231,-253}, { -91, -82}, {-172,-145}, { -22,-317}, { -90,-356}, {-382,-159}, { 326, 327}, { 328, 329},
    { 330, 331}, { 332, 333}, { 334, 335}, {-106,-263}, {-278,-215}, {-110, -39}, {-101,-377}, {-129, -63},
    {-436,-195}, {-506,-531}, { 336,-212}, {-154,-266}, { -59,-288}, {-292,-303}, {-337,-432}, {-188,-451},
    {-456,-460}, {-501,-236}, {-551, 337}, { 338, 339}, { 340, 341}, { 342, 343}, { 344, 345}, { 346, 347},
    { 348, 349}, { 350, 351}, { 352, 353}, { 354, 355}, { 356, 357}, { 358, 359}, { 360, 361}, { 362, 363},
    { 364, 365}, { 366, 367}, { 368, 369}, { 370, 371}, { 372, 373}, { 374, 375}, { 376, 377}, { 378, 379},
    { 380, 381}, { 382, 383}, { 384, 385}, { 386, 387}, { 388, 389}, { 390, 391}, { 392, 393}, { 394, 395},
    { 396, 397}, { 398, 399}, { 400, 401}, { 402, 403}, { 404, 405}, { 406, 407}, { -72,-272}, {-309,-333},
    {-340,-360}, { -68,-387}, {-184,-416}, {-427,-147}, {-435,-437}, {-115,-480}, {-510,-532}, {-164,-556},
    { 408,-295}, {-296,-297}, {-107,-313}, {-193,-173}, {-320,-327}, {-341,-351}, {-352,-143}, {-378, -19},
    {-403,-412}, {-268, -54}, { -83,-441}, {-442,-457}, {-475, -44}, { -97,-511}, {-515,-208}, {-527,-528},
    {-237,-536}, {-552, 409}, { 410, 411}, { 412, 413}, { 414, 415}, { 416, 417}, { 418, 419}, { 420, 421},
    { 422, 423}, { 424, 425}, { 426, 427}, { 428, 429}, { 430, 431}, { 432, 433}, { 434, 435}, { 436, 437},
    { 438, 439}, { 440, 441}, { 442, 443}, { 444, 445}, { 446, 447}, { 448, 449}, { 450, 451}, { 452, 453},
    { 454, 455}, { 456, 457}, { 458, 459}, { 460, 461}, { 462, 463}, { 464, 465}, { 466, 467}, { 468, 469},
    { 470, 471}, { 472, 473}, { 474, 475}, { 476, 477}, { 478, 479}, { 480, 481}, { 482, 483}, { 484, 485},
    { 486, 487}, { 488, 489}, { 490, 491}, { 492, 493}, { 494, 495}, { 496, 497}, { 498, 499}, { 500, 501},
    { 502, 503}, { 504, 505}, { 506, 507}, { 508, 509}, { 510, 511}, { 512, 513}, { 514, 515}, { 516, 517},
    { 518,-104}, { -84,-218}, {-318,-319}, {-117,-321}, {-322,-323}, {-219,-174}, {-243,-328}, {-329, -94},
    {-228,-194}, {-240,-334}, {-102,-229}, {-169,-338}, {-339,-116}, {-289,-342}, {-343,-345}, {-346,-347},
    { -23,-203}, {-214,-353}, {-204,-220}, {-357,-358}, {-264,-361}, {-362,-363}, {-365,-366}, {-367, -92},
    {-245,-121}, {-293,-379}, {-108,-232}, {-221,-383}, {-384,-233}, {-294,-241}, {-388,-389}, {-390,-391},
    {-392,-393}, {-394,-395}, {-396,-397}, {-398, -24}, {-109,-149}, {-242,-404}, { -64, -79}, { -89,-408},
    {-409,-213}, {-120,-113}, {-413,-414}, {-415, -96}, {-417,-418}, {-419,-420}, {-421,-422}, {-423,-298},
    { -69,-269}, {-428,-429}, { -78,-270}, { -88,-433}, {-434,-271}, {-234,-259}, {-438,-439}, {-440,-227},
    {-179,-443}, {-445,-446}, {-447,-223}, {-238,-452}, {-453,-454}, {-273,-254}, {-246,-458}, {-459, -48},
    {-461,-462}, {-463,-465}, {-466,-467}, {-468,-470}, {-471,-304}, {-476,-477}, {-478,-112}, {-481,-482},
    {-483,-485}, {-486,-487}, {-490,-491}, {-103,-118}, {-502,-503}, {-504,-189}, { -93,-507}, {-508,-509},
    {-148,-139}, {-512,-513}, {-308,-516}, {-517,-518}, {-520,-521}, { -73, -98}, { -95, -49}, {-529,-222},
    {-217,-197}, {-533,-534}, {-535,-284}, {-537,-538}, {-540,-541}, {-542,-543}, {-545,-546}, {-144,-198},
    {-314,-553}, {-209,-279}, {-557,-558}, {-560,-561}, {-562,-563}, {-565,-566}, {-567,-575}, {-576,-577},
    {-578,-580}, {-581,-582}, {-583,-585}, {-586,-587}, {-590,-591}, {-600,-601}, {-605,-606},
};

const int16_t mlt_decoder_tree_category_4[208][2] =
{
    {   1,   2}, {   3,   0}, {   4,   5}, {   6,   7}, {   8,   9}, {  10,  11}, {  12, -64}, {  -1,  13},
    {  14, -16}, {  -4,  15}, {  16,  17}, {  18, -80}, {  -5,  19}, {  20,  21}, { -20,  22}, {  23, -65},
    { -84, -21}, { -68,  24}, { -17,  25}, {  26,  27}, {  28, -81}, { -69, -85}, {  29,  30}, {  31,  32},
    {-128,  33}, {  34,  35}, {  -2,  36}, {  37,  38}, {-144,  39}, {  40,  -6}, {  41,  42}, { -32,  43},
    {  44,  -8}, {  45, -25}, { -96,  46}, {  47,-100}, {  -9,  48}, {  49, -36}, {  50, -24}, {  51,  52},
    {  53,-148}, {  54,  55}, { -22,  56}, {  57,  58}, {-132, -89}, {  59,  60}, {-101,  61}, { -37,  62},
    { -18,  63}, { -88,-129}, { -66, -70}, { -97,  64}, { -72, -73}, {  65,-145}, {-149, -86}, {  66, -33},
    {  67,-133}, {  68,  69}, {  70,  71}, {-192,  72}, {  73,-160}, { -82,  74}, {-164,  75}, { -10,  76},
    {  77,-208}, {  78, -40}, {  79,  80}, {  -3,  81}, {  -7,  82}, {  83,  84}, {-104,  85}, {  86, -26},
    {  87,-105}, {  88,-112}, {  89,  90}, {  91, -41}, {  92,  93}, {  94,  95}, { -48,  96}, { -90,  97},
    {  98, -28}, { -52,  99}, { -12, 100}, { 101, -74}, { -13,-116}, {-161, 102}, { 103, -29}, {-102, 104},
    {-152,-165}, { 105, 106}, { 107, 108}, { 109, 110}, { 111,-212}, { 112, 113}, {-136, 114}, { 115,-137},
    { 116, -23}, { -19,-153}, { -98,-134}, {-196, 117}, { 118, 119}, { -38,-193}, {-113,-150}, {-209, 120},
    { 121, -93}, { -83, 122}, { 123, 124}, { 125, 126}, { 127, 128}, { 129, 130}, { 131, -34}, {-146, -53},
    { 132, 133}, { 134, 135}, { 136, 137}, { 138,-130}, { -49, 139}, { 140, 141}, {-117, -42}, { -67, -92},
    { 142, -87}, { -77,-197}, { -71, 143}, { 144, 145}, { 146, 147}, { 148, 149}, { 150, 151}, { 152, 153},
    { 154, 155}, { 156, 157}, { 158, 159}, { 160, 161}, { 162, 163}, { 164, 165}, { 166, 167}, { 168, 169},
    {-108, -76}, {-168,-169}, {-176, -44}, {-224, -56}, { -45,-180}, { -11,-106}, {-213, 170}, { 171, 172},
    { 173, 174}, { 175, 176}, { 177, 178}, { 179, 180}, { 181, 182}, { 183, 184}, { 185, 186}, { 187, 188},
    { 189, 190}, { 191, 192}, { 193, 194}, { 195, 196}, { 197, 198}, { 199, 200}, { 201, 202}, { 203, 204},
    { 205, 206}, { 207,-131}, { -30, -27}, { -43,-151}, { -75,-154}, {-156,-162}, {-109,-194}, {-198,-201},
    {-114,-225}, {-228,-229}, {-141,-142}, { -94,-124}, { -95,-147}, {-115,-125}, { -54, -55}, {-107, -58},
    { -39,-155}, {-121,-157}, {-158,-103}, { -14,-122}, {-163, -51}, { -57,-166}, {-167, -46}, {-110,-170},
    {-172,-173}, { -61,-177}, {-178, -99}, {-181,-182}, {-184,-185}, {-118, -35}, { -15,-195}, { -31, -60},
    {-135,-199}, {-200, -79}, {-202,-204}, {-205,-119}, { -91,-210}, {-211, -78}, {-120,-214}, {-215,-216},
    {-217,-218}, {-220,-221}, { -50,-138}, {-226,-139}, {-140,-230}, {-232,-233}, {-240,-241}, {-244,-245},
};

const int16_t mlt_decoder_tree_category_5[191][2] =
{
    {   1,   2}, {   0,   3}, {   4,   5}, {   6,   7}, {   8,   9}, {  10,  11}, { -81,  -1}, {  12,  13},
    {  14, -27}, {  -3,  -9}, {  15,  16}, {  17,  18}, {  19,  20}, {-108,  21}, {  -4,  22}, {  23, -36},
    { -12,  24}, { -82,  25}, {  26, -84}, {  27, -90}, { -10, -30}, {  28,  29}, {  30, -28}, {  31,-117},
    { -13,  32}, { -39,  33}, {  34,-109}, {  35, -93}, { -85,-111}, { -37,  36}, { -31,  37}, { -91,  38},
    {  39,  40}, { -40,-120}, {  41,  42}, {-118,  43}, { -94,  44}, {-112,-162}, {  45,  46}, {  -2,  47},
    {  48,  49}, {-121,-189}, {  50, -54}, {  51,  52}, {  53, -18}, {  54,  55}, {  -6,  56}, {  57,  -5},
    {-135,  58}, {  59,  60}, {  61,  62}, { -63,  63}, {  64,  -7}, { -15,  65}, {  66,  67}, { -45,  68},
    {  69,  70}, {  71, -21}, {  72,  73}, {  74,  75}, {  76,  77}, {-163,  78}, {  79,-171}, {-144,  80},
    { -48,  81}, { -57,  82}, {  83,  84}, {-165,  85}, { -16,-198}, {  86,  87}, { -11,  88}, {  89, -99},
    {  90, -83}, { -19,  91}, {  92,  93}, {  94,  95}, {  96,  97}, {  98,  99}, { -87, 100}, { 101, 102},
    {-190, -66}, { -33,-192}, { 103, 104}, { 105, 106}, {-102, -42}, { 107,-126}, { 108, -29}, {-129, -46},
    { -86, -14}, {-114, -32}, {-172, 109}, { 110, -58}, { -34,-138}, { 111, 112}, { 113, 114}, { 115, 116},
    { 117, 118}, { 119, 120}, {-127,-166}, {-174, 121}, { 122, 123}, { 124, 125}, { -88, -96}, { 126,-100},
    { -38,-110}, { -22,-136}, { -55,-139}, {-201, 127}, { -64,-193}, { 128, -49}, {-175,-199}, { 129, 130},
    { 131, 132}, { 133, 134}, { 135, 136}, { 137, 138}, { 139, 140}, { 141, 142}, { 143, 144}, { 145, 146},
    { 147, 148}, { 149, 150}, {-103, -92}, { -43,-130}, {-145,-147}, {-148, -41}, {-216,-115}, {-119,-123},
    { -95, 151}, { 152, 153}, { 154, 155}, { 156, 157}, { 158, 159}, { 160, 161}, { 162, 163}, { 164, 165},
    { 166, 167}, { 168, 169}, { 170, 171}, { 172, 173}, { 174, 175}, { 176, 177}, { 178, 179}, { 180, 181},
    { 182, 183}, { 184, 185}, { 186, 187}, { 188, 189}, { 190,-153}, {-180,  -8}, { -97, -24}, {-122,-113},
    {-124,-125}, { -67, -44}, {-128, -69}, {-106,-131}, {-132,-133}, { -61, -73}, {-137,-116}, { -89,-140},
    {-141,-142}, { -23, -25}, {-146, -17}, {-104,-149}, {-150,-151}, { -52,-154}, {-156,-157}, { -76, -70},
    {-164, -51}, { -72,-167}, {-168,-169}, { -47, -20}, {-173, -59}, {-101,-176}, {-177,-178}, { -68,-181},
    {-183,-184}, { -35, -60}, {-191, -98}, { -56,-194}, {-195,-196}, { -75, -65}, {-200,-105}, {-202,-203},
    {-204,-205}, {-207,-208}, {-210,-211}, { -50,-217}, {-219,-220}, {-225,-226}, {-228,-229},
};

const int16_t mlt_decoder_tree_category_6[31][2] =
{
    {   1,   0}, {   2,   3}, {   4,   5}, {   6,   7}, {   8, -16}, {  -1,  -8}, {  -2,  -4}, {   9,  10},
    {  11,  12}, {  13,  14}, {  15,  16}, {  17, -24}, {  -3, -12}, {  -6,  18}, {  19, -20}, { -10,  -5},
    { -17,  -9}, { -18,  20}, {  21,  22}, {  23,  24}, {  25, -28}, {  26,  -7}, { -14, -22}, { -26, -11},
    {  27, -19}, { -25, -13}, { -21,  28}, {  29, -30}, { -27,  30}, { -15, -29}, { -23, -31},
};

const int16_t *table_of_decoder_tables[NUM_CATEGORIES - 1] =
{
    (const int16_t *) mlt_decoder_tree_category_0,
    (const int16_t *) mlt_decoder_tree_category_1,
    (const int16_t *) mlt_decoder_tree_category_2,
    (const int16_t *) mlt_decoder_tree_category_3,
    (const int16_t *) mlt_decoder_tree_category_4,
    (const int16_t *) mlt_decoder_tree_category_5,
    (const int16_t *) mlt_decoder_tree_category_6
};
/*- End of file ------------------------------------------------------------*/
